#ifndef __gxframework_graphicsdevice_h__
	#define __gxframework_graphicsdevice_h__

#include "shared.h"
#include "pixelformat.h"
#include "graphicscontext.h"
#include "viewport.h"

namespace Gx
{
	class DeviceContext;
	class Window;
	class Game;

	class GXFRAMEWORK_DECLSPEC GraphicsDevice
	{
	public:
		GraphicsDevice();
		~GraphicsDevice();

		void setGame(Game& game);
		void setVerticalSync(bool value);
		bool setPixelFormat(IPixelFormat& pf);
		bool setGraphicsContext(IGraphicsContext& context);
		void swapBuffers();

		Viewport getViewport() const;
		int getPixelFormatIndex() const;

		bool isDoubleBuffered() const {
			return m_doubleBuffered;
		}

		Window& getWindow() {
			return *m_window;
		}

	protected:
		void resetGraphicsContext();

	private:
		GraphicsDevice(const GraphicsDevice&);
		GraphicsDevice& operator=(const GraphicsDevice&);

		bool			m_doubleBuffered;	// decyduje czy wywoywa SwapBuffers
		Window*			m_window;			// aktualnie powizane okno
		DeviceContext*	m_deviceContext;	// aktualnie powizany kontekst urzdzenia;
	};
}

#endif // ~__gxframework_graphicsdevice_h__
